﻿#RequireAdmin
#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Images\logo.ico
#AutoIt3Wrapper_Outfile=VembuBDR Recovery CD Builder.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=VembuBDR Recovery CD Builder
#AutoIt3Wrapper_Res_Description=VembuBDR Recovery CD Builder
#AutoIt3Wrapper_Res_Fileversion=0.6.1.0
#AutoIt3Wrapper_Res_LegalCopyright=Vembu Technologies Pvt. Ltd. (c) 2004 - 2014
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#AutoIt3Wrapper_Res_Field=ProductVersion|12
#AutoIt3Wrapper_Res_Field=ProductName|VembuBDR Recovery CD Builder
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#AutoIt3Wrapper_Run_Before=copy "%in%" "c:\program files\autoit3\SciTE\AutoIt3Wrapper"
#AutoIt3Wrapper_Run_Tidy=y
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Run_Debug_Mode=Y
;~ Header Files

#include <GUIConstantsEx.au3>
#include <guibutton.au3>
#include <Misc.au3>
#include <EditConstants.au3>
#include <GuiEdit.au3>
#include <File.au3>
#include <Process.au3>
#include <GuiToolTip.au3>
#include <date.au3>
#include <WindowsConstants.au3>
#include <GuiToolTip.au3>
#include <AVIConstants.au3>
#include <WinAPI.au3>
#include ".\AutoitIncludes\_XMLDomWrapper.au3"
#include <Array.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GuiListView.au3>

;~ Debug mode

;~ Trayicon Debug

AutoItSetOption("TrayAutoPause", 0)
AutoItSetOption("GUICloseOnESC", 1)
AutoItSetOption("TrayIconDebug", 1)

Global $g_SelectedUSB, $g_DestinationType, $g_USBDetails, $g_SelectedDriveLetter, $g_USBLists, $g_PartitioningType
Global $dir, $dirup1, $LogDir, $ret, $SC_VERSION
Global $var, $Link_Label, $Error16, $Error15, $Status_Group1, $Aik_Target, $Drv_Target, $NotesTitle_Label, $Uppercase_Var, $AboutBtn, $Finish_Bn, $combo_1, $Browse_Bn1, $TargetLocation_Label, $WaikLocation_Label, $label_3, $TargetLocation_Input, $gui, $Browse_Bn, $Build_Bn, $Cancel_Bn, $LogDir, $msg, $WaikLocation_Input, $Aik, $ChangeDir, $changedir1, $Status_Group, $source, $pemount, $progress_bar1, $i, $ProgressLabel, $Set_Target, $folder, $File1, $time, $Isoname, $Additional_Driver_Location_Label, $Additional_Driver_Location_Input, $Addtinal_Driver_Button, $Side_Image, $retainTempFiles

Global $LicenseDialog, $LicenseData, $acceptButton, $declineButton

Global $ProductName, $CompanyName, $BuildNo, $FileOpen, $Header, $HeaderDisc, $WebURL, $SupportMailID, $nMsg

Global $Link_Label_For_ADK,$Win_ADKPath, $Win_PE_Tools_Path, $Dism_path, $OscdImage_path , $isWinAdk ,$BootWIMTempTargetLoc ,$BootWIMTempSourceLoc, $Win_PE_Cabinet_path


;--  Set Directory For Log   ---
$dir = @ScriptDir
;$dirup1 = _upone($dir)
$LogDir = $dir & "\Logs"
DirCreate($LogDir)
;--    End              ---

; -- Go to Previous Folder --
Func _upone($arg)
	$ret = StringLeft($arg, StringInStr($arg, '\', 0, -1) - 1)
	Return $ret
EndFunc   ;==>_upone

; - End           ---


;start config xml read

$FileOpen = _XMLFileOpen($dir & "\PEConf\sgconfig.xml")

;if $FileOpen = -1 Then
;MsgBox(48, "Open File Correctly?", "NO")
;else
;MsgBox(0, "File ?", $FileOpen)
;EndIf


$node = "//ProductName"
$ProductName = _GetFirstValue($node)
$node = "//CompanyName"
$CompanyName = _GetFirstValue($node)
$node = "//BuildNo"
$BuildNo = _GetFirstValue($node)
$node = "//WebURL"
$WebURL = _GetFirstValue($node)
$node = "//SupportMailID"
$SupportMailID = _GetFirstValue($node)

;$Version = _XMLGetAttrib('(/SOFTPKG)', 'VERSION')
;$Dependency = _XMLGetAttrib('(//CODEBASE)', 'HREF')
;_XMLGetField('(//TITLE)')

;If $Title = -1 Then
;	MsgBox(48, "Error", "Could Not Load values")
;Else
;	MsgBox(0, "Test Window", $Title)
;EndIf
;end config xml read

; ---        Print Log Header        ---

_FileWriteLog($LogDir & "\SG_Recovery.log", "")
_FileWriteLog($LogDir & "\SG_Recovery.log", "")
_FileWriteLog($LogDir & "\SG_Recovery.log", "----------------------" & $ProductName & " Recovery CD Builder Wizard ----------------------------")
_FileWriteLog($LogDir & "\SG_Recovery.log", "---Platform: Windows 7; Windows 2008,Windows xp,Windows 2003,Windows vista----")
_FileWriteLog($LogDir & "\SG_Recovery.log", "------------------------" & $Set_Target & " & Recovery ---------------------------")
_FileWriteLog($LogDir & "\SG_Recovery.log", "------------------ " & @YEAR & $CompanyName & " All Rights Reserved.--------------------")
_FileWriteLog($LogDir & "\SG_Recovery.log", "")
_FileWriteLog($LogDir & "\SG_Recovery.log", "")


;~ Check if Already Recovery cd Build is running

$SC_VERSION = "SCISO"; name of the script
; If It already running	 Exit


; ---             End                 ------


;--  Check if Already Recovery cd Build is running ---

;  -- Set Name of the Script --
$SC_VERSION = "SCISO"

If WinExists($SC_VERSION) Then

	MsgBox(16, $ProductName & " Alerts", $ProductName & " Recovery CD Build is Already Running ")

	_FileWriteLog($LogDir & "\SG_Recovery.log", $ProductName & " Recovery CD Builder is Already Running")
	Exit; If It already running	 Exit
EndIf

; ---               End                       --


;~ Set Windows Title ---------
AutoItWinSetTitle($SC_VERSION)

Lic_Gui_Creation()

Func Lic_Gui_Creation()

	Opt('MustDeclareVars', 1)
	Opt("GUIResizeMode", 1)
	;  --- 					Create GUI 627x460               --------

	#region ### START Koda GUI section ### Form=
	$LicenseDialog = GUICreate($ProductName & " Recovery CD Builder", 628, 400, -1, -1)
	;  --- 						End 								----

	;  ---					Set Top Banner From Images Folder -----
	GUICtrlCreatePic(@ScriptDir & "\Images\WinPE.gif", 0, 0, 627, 64)
	; 	---						End 				----

	; ------    Function for finding the previously installed Waik location -----
	;Find_Waik_Location()
	; ------    						End 								-----

	Opt("GUICoordMode", 3)

	$Side_Image = GUICtrlCreatePic(@ScriptDir & "\Images\banner_icon.bmp", 536, 2, 73, 53)
	$Header = GUICtrlCreateLabel("SERVICE PROVIDER LICENSE AGREEMENT", 32, 16, 300)
	_BKColor(-1, $Header)
	GUICtrlSetFont(-1, 11, 800, 2, "Arial")
	$HeaderDisc = GUICtrlCreateLabel("Read and accept the License Agreement ", 56, 40, 412, 18)
	GUICtrlSetFont(-1, 8, 400, 0, "Arial")
	_BKColor(-1, $HeaderDisc)

	Local $file = FileRead(@ScriptDir & "\PEConf\LICENSE.TXT")
	$LicenseData = GUICtrlCreateEdit($file, 15, 80, 593, 251, $ES_AUTOVSCROLL + $WS_VSCROLL + $ES_READONLY)
	$acceptButton = GUICtrlCreateButton("Agree", 184, 362, 75, 25)
	$declineButton = GUICtrlCreateButton("Decline", 328, 362, 75, 25)
	;GUISetState(@SW_SHOW)
	GUISetState()
	#endregion ### END Koda GUI section ###

	While 1
		$nMsg = GUIGetMsg()
		Switch $nMsg
			Case $GUI_EVENT_CLOSE
				GUIDelete($LicenseDialog)
				Exit
				;Case $msg = $AboutBtn
				;_AboutProgram()
			Case $acceptButton
				_FileWriteLog($LogDir & "\SG_Recovery.log", "Accept Operation Triggered ")
				GUISetState(@SW_HIDE, $LicenseDialog)
				Return
			Case $declineButton
				_FileWriteLog($LogDir & "\SG_Recovery.log", "Cancel Operation Triggered ")
				GUIDelete($LicenseDialog)
				Exit
		EndSwitch
	WEnd

EndFunc   ;==>Lic_Gui_Creation

Func _GetFirstValue($node)
	Local $ret_val = _XMLGetValue($node)
	If IsArray($ret_val) Then
		Return ($ret_val[1])
	Else
		Return SetError(1, 3, 0)
	EndIf
EndFunc   ;==>_GetFirstValue



;~ ConsoleWrite(@OSArch)

; For Building a X86 Iso
;Global $Version = "x86"

; For Building a X64 Iso
Global $Version = "amd64"

_FileWriteLog($LogDir & "\SG_Recovery.log", "Build version " & $Version & " OS Version "&@OSVersion & " OS Architecture " &@OSArch)

; Check The OS Architecture and Continue....
If @OSArch = "X86" Then
	If $Version = "amd64" Then
		MsgBox(262144, 'Debug line ~' & @ScriptLineNumber, 'Selection:' & @LF & '$Version' & @LF & @LF & 'Return:' & @LF & $Version) ;### Debug MSGBOX		MsgBox(16, $ProductName & " Alerts", "The version of this file is not compatible with the version of Windows you're running. Check you computer system infromation to see whether you need an x86 (32-bit) or x64 (64-bit) version of the program, and then contact the software publisher.")
	Else
		Gui_Creation()
	EndIf
Else
	Gui_Creation()
EndIf



Func Gui_Creation()
	
	; Start the media type selection page
	GUICtrlDelete($LicenseDialog)
	
	; Start the media type selection page
	MediaTypeSelectionPage()

	Opt('MustDeclareVars', 1)
	Opt("GUIResizeMode", 1)
	;  --- 					Create GUI 627x460               --------

	#region ### START Koda GUI section ### Form=
	$gui = GUICreate($ProductName & " Recovery CD Builder", 627, 460, -1, -1) ; will create a dialog box that when displayed is centered

	;  --- 						End 								----

	;  ---					Set Top Banner From Images Folder -----
	GUICtrlCreatePic(@ScriptDir & "\Images\WinPE.gif", 0, 0, 627, 64)
	; 	---						End 				----

	; ------    Function for finding the previously installed Waik location -----
	;Find_Waik_Location()
	; ------    						End 								-----

	Opt("GUICoordMode", 3)

	;  --- 				Create the group and Label in center of the application ------
	$Status_Group1 = GUICtrlCreateGroup("Notes", 50, 200, 527, 80)
	$NotesTitle_Label = GUICtrlCreateLabel("Install Windows AIK/ADK  before creating " & $ProductName & " Recovery CD  ", 80, 220)
	$Link_Label_For_ADK = GUICtrlCreateLabel(" ADK - https://docs.microsoft.com/en-us/windows-hardware/get-started/adk-install", 80, 260, 500,70)
	GUICtrlSetFont(-1, 8.5, 400, 4) ;Font style for group
	GUICtrlSetColor(-1, 0x151B8D) ; color of the font in $link_label
	$Link_Label = GUICtrlCreateLabel(" AIK - https://www.microsoft.com/en-us/download/details.aspx?id=5753", 80, 240)

	GUICtrlSetCursor($Link_Label, 0);On mouse over change the mouse pointer
	GUICtrlSetCursor($Link_Label_For_ADK, 0);
	GUICtrlSetFont(-1, 8.5, 400, 4) ;Font style for group
	GUICtrlSetColor(-1, 0x151B8D) ; color of the font in $link_label
	;	---							End       		   ----

	; ----				Location Label 					---
	
	If $g_DestinationType = "ISO" Then
		$TargetLocation_Label = GUICtrlCreateLabel("Target location:", 50, 120, 84, 20)	
	ELSE
		$TargetLocation_Label = GUICtrlCreateLabel("Target USB :", 50, 120, 84, 35)
	ENDIF

	$WaikLocation_Label = GUICtrlCreateLabel("AIK/ADK location:", 50, 80)
	$Additional_Driver_Location_Label = GUICtrlCreateLabel("Additional Driver", 48, 160, 100, 17)
	; 	--- 					End 					---


	;	---				check if $WaikLocation_Input is Null If null means set the label in to install waik location    ----
	If $Aik_Target = "" Then
		$label_3 = GUICtrlCreateLabel(" Select the installed WAIK/WADK location Eg: C:\Program Files\Windows AIK ", 100, 350, 507, 23)
	EndIf
	; ---				End											---

	$ProgressLabel = GUICtrlCreateLabel("", 80, 300, 330, 15)
	Opt("GUICoordMode", 4)
	$WaikLocation_Input = GUICtrlCreateInput("", 156, 120, 334, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_READONLY))
	;
	Global $Set_Target = @HomeDrive & "\"
	If $g_DestinationType = "ISO" Then
	GUICtrlSetData($WaikLocation_Input, $Set_Target)
	GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
	Else
	GUICtrlSetData($WaikLocation_Input, $g_SelectedDriveLetter)
	GUICtrlSetTip($WaikLocation_Input, "Target Device :" & $g_USBDetails)
	EndIf
	$TargetLocation_Input = GUICtrlCreateInput("", 156, 80, 334, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_READONLY))
	$Additional_Driver_Location_Input = GUICtrlCreateInput("", 156, 160, 334, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_READONLY))
	;Find if Win Aik already installed
	;Find_Waik_Location()
	;
	Opt("GUICoordMode", 5)
	$Browse_Bn = GUICtrlCreateButton("Browse...", 510, 120, 85, 23)
	GUICtrlSetState($Browse_Bn, $GUI_INDETERMINATE)
	$Browse_Bn1 = GUICtrlCreateButton("Browse...", 510, 79, 85, 23)
	If $g_DestinationType = "USB" Then
	GUICtrlSetState($Browse_Bn, $GUI_DISABLE)
	EndIf
	$Addtinal_Driver_Button = GUICtrlCreateButton("Browse..", 512, 160, 81, 25)
	$Finish_Bn = GUICtrlCreateButton("Finish", 350, 410, 100)
	GUICtrlSetTip($Finish_Bn, "Finish")
	GUICtrlSetState($Finish_Bn, $GUI_DISABLE)
	Opt("GUICoordMode", 1)
	$Build_Bn = GUICtrlCreateButton("Build", 150, 410, 100)
	GUICtrlSetState($Build_Bn, $GUI_FOCUS)
	GUICtrlSetTip($Build_Bn, "Build")
	Opt("GUICoordMode", 6)
	$Status_Group = GUICtrlCreateGroup("Status", 50, 280, 527, 100)
	GUIStartGroup()
	$progress_bar1 = GUICtrlCreateProgress(60, 325, 507, 23)
	GUICtrlSetColor(-1, 32250)
	Opt("GUICoordMode", 7)
	Opt("TrayOnEventMode", 1)
	Opt("TrayMenuMode", 1)


	GUICtrlSetTip($Additional_Driver_Location_Input, "Additional Driver Location: Set a folder path, which contain driver files which are not natively supported by windows 7")


	Global $exititem = TrayCreateItem("About")
	TrayItemSetOnEvent(-1, "About")
	Global $exititem = TrayCreateItem("Exit")
	TrayItemSetOnEvent(-1, "cancel")
	TraySetClick(16) ;This will tell the trayicon to only react on rightklick with mouse
	TraySetState()
	$Cancel_Bn = GUICtrlCreateButton("Cancel", 350, 410, 100)
	$Side_Image = GUICtrlCreatePic(@ScriptDir & "\Images\banner_icon.bmp", 536, 2, 73, 53)
	$Header = GUICtrlCreateLabel($ProductName & " Recovery CD Builder", 32, 16, 440, 21)
	_BKColor(-1, $Header)
	GUICtrlSetFont(-1, 11, 800, 2, "Arial")
	$HeaderDisc = GUICtrlCreateLabel("This wizard will help you to build Recovery CD to restore existing " & $ProductName & " backup images", 56, 40, 412, 18)
	GUICtrlSetFont(-1, 8, 400, 0, "Arial")
	_BKColor(-1, $HeaderDisc)

	$retainTempFiles = GUICtrlCreateCheckbox("Retain temporary files(Optional)", 60, 380)
	GUICtrlSetTip($retainTempFiles, "Needed only for creating Recovery USB")

	; TODO ELAPSED TIME

	GUISetState(@SW_SHOW)
	;Find if Win Aik already installed
	Find_Waik_Location()
	#endregion ### END Koda GUI section ###
	While 1

		$msg = GUIGetMsg()
		Select
			Case $msg = $GUI_EVENT_CLOSE
				GUIDelete($gui)
				Exit
				;Case $msg = $AboutBtn
				;_AboutProgram()
			Case $msg = $Browse_Bn1
				Modaldialog()
				browse1()
			Case $msg = $Addtinal_Driver_Button
				Modaldialog()
				browseDriver()
			Case $msg = $Browse_Bn
				Modaldialog()
				GUICtrlSetData($progress_bar1, 0)
				browse()
			Case $msg = $Build_Bn
				GUICtrlSetData($Cancel_Bn, "Cancel")
				GUICtrlSetData($progress_bar1, 0)
				If $Set_Target = "" Then
					MsgBox(16, $ProductName & " Alerts ", "Location invalid                  ")
					_FileWriteLog($LogDir & "\SG_Recovery.log", "Location Invalid")
				ElseIf $Set_Target = @HomeDrive & "\" Then
					_FileWriteLog($LogDir & "\SG_Recovery.log", "Destination Path is " & $Set_Target & "\ISO\Recovery CD.iso")
					Checkfiles()
				Else
					Checkfiles()
				EndIf
			Case $msg = $Link_Label
				ShellExecute("http://www.microsoft.com/downloads/en/details.aspx?FamilyID=696dd665-9f76-4177-a811-39c26d3b3b34&displaylang=en")
			Case $msg = $Link_Label_For_ADK
				ShellExecute("https://docs.microsoft.com/en-us/windows-hardware/get-started/adk-install")
			Case $msg = $Finish_Bn
				Cancel()
				Exit
			Case $msg = $Cancel_Bn
				GUICtrlSetOnEvent($Cancel_Bn, "cancel")
				Cancel()
		EndSelect
	WEnd
EndFunc   ;==>Gui_Creation




; ##################Function for check WAIK if already installed or not
;~ Func IsInstalled($progName);~
;~     Local $InstallPrograms = GetList();~
;~     If $InstallPrograms == -1 Then Return -1 ; Cannot get list
;~     For $program in $InstallPrograms;~
;~         if StringLower($program.Caption) == StringLower($progName) Then;~
;~             ConsoleWrite($program.Caption & " : " & $progName & @CRLF);~
;~             Return 1;;~
;~         EndIf;~
;~     Next;~
;~     Return -2 ; Didn't find program.;~
;~ EndFunc
;~ Func GetList();~
;~     Local  $wbemFlagReturnImmediately = 0x10;~
;~     Local  $wbemFlagForwardOnly = 0x20;~
;~     Local  $colItems = "";~
;~ 	Local $strComputer = "localhost"
;~     Local  $Output="";~
;~     $Output &= "Computer: " & $strComputer  & @CRLF;~
;~     Local  $objWMIService = ObjGet("winmgmts:\\" & $strComputer & "\root\CIMV2");~
;~ 	Local   $colItems = $objWMIService.ExecQuery("SELECT * FROM Win32_Product", "WQL", _
;~                                               $wbemFlagReturnImmediately + $wbemFlagForwardOnly)
;~     If IsObj($colItems) Then;~
;~         Return $colItems;~
;~     EndIf;~
;~     Return -1;~
;~ EndFunc
;~ To FInd Installed Location



; Check if already installed or not in program file (it will check all the partitions present in Operating system )

Func Find_Waik_Location()

Local $KitsOsVersionArray[3] = ["10", "81", ""] ; KitsRoot10 - Windows 10, KitsRoot81 - Windows 8.1, KitsRoot - Windows 8


   If $Win_ADKPath ="" Then
	  Local $ArrayIndex = 0
	  While $ArrayIndex < 3
		 _FileWriteLog($LogDir & "\SG_Recovery.log", "$KitsOsVersionArray value :" & $KitsOsVersionArray[$ArrayIndex])
		 $Win_ADKPath = GetADKInstallPathFromRegistry($KitsOsVersionArray[$ArrayIndex],@OSArch)
		 If $Win_ADKPath <> "" Then
			$Aik_Target = $Win_ADKPath & "Assessment and Deployment Kit"
			$Win_PE_Tools_Path = "\Windows Preinstallation Environment"
			$Win_PE_Cabinet_path = "\WinPE_OCs"
			$Dism_path ="\Deployment Tools\"& $Version &"\DISM"
			$OscdImage_path = "\Deployment Tools\"&$Version&"\Oscdimg"
			$isWinAdk = 1
			ExitLoop
		 EndIf
		 $ArrayIndex = $ArrayIndex+1
		 ; Avoid high CPU usage.
		 Sleep(50)
	  WEnd
   EndIf

   If $Aik_Target ="" Then
	   Global $var1 = DriveGetDrive("all")
	   Local $handle, $answer
	   For $j = 1 To $var1[0]
		   $handle = FileFindFirstFile($var1[$j] & "\Program Files\Windows AIK\Tools\PETools\*.dll")
		   If $handle <> -1 Then
			   $Uppercase_Var = StringUpper($var1[$j])
			   $Aik_Target = $Uppercase_Var & "\Program Files\Windows AIK\Tools"
			   $Win_PE_Tools_Path ="\PETools"
			   $Win_PE_Cabinet_path = "\WinPE_FPs"
			   $Dism_path = "\Servicing"
			   $OscdImage_path = "\"& $Version
			   $isWinAdk = 0
			   _FileWriteLog($LogDir & "\SG_Recovery.log", "Windows Aik/ADK Location :" & $Aik_Target)
		   EndIf
		   FileClose($handle)
	   Next
		 GUICtrlSetData($TargetLocation_Input, $Aik_Target)
		 GUICtrlSetTip($TargetLocation_Input, "Windows AIK/ADK Location : " & $Aik_Target)

   EndIf
   GUICtrlSetData($TargetLocation_Input, $Aik_Target)
   GUICtrlSetTip($TargetLocation_Input, "Windows AIK/ADK Location : " & $Aik_Target)

EndFunc   ;==>Find_Waik_Location

; ------        End Find_Waik_Location   -------------



Func About()
	Modaldialog()
	MsgBox(64, "About:", $Set_Target & " Recovery CD Builder" & @CRLF & $WebURL & @CRLF & "Copyright © " & $CompanyName)
	Modallessdialog()
EndFunc   ;==>About


Func Cancel()

	_FileWriteLog($LogDir & "\SG_Recovery.log", "Exit Function")
	Exit

EndFunc   ;==>Cancel


Func browse()
	; Function for browsing the target(to save the ISO)
	$Set_Target = FileSelectFolder("Choose a folder.", "", 5, @HomeDrive & "\")
	Local $error9 = FileGetAttrib($Set_Target)

	If $Set_Target = "" Then
		$Set_Target = @HomeDrive & "\"
		GUICtrlSetData($WaikLocation_Input, $Set_Target)
		GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Target location : " & $Set_Target)
		Modallessdialog()
	Else
		;Check if target is null or computer or Libraries it will show an error
		If $error9 = "" Or $Set_Target = "Computer" Or $Set_Target = "Libraries" Then
			Modaldialog()
			MsgBox(16, $ProductName & " Alerts", "Invalid Location .Try Some other Location")
			$Set_Target = @HomeDrive & "\"
			GUICtrlSetData($WaikLocation_Input, $Set_Target)
			GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code File GET Attrib" & $error9)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Target location : " & $Set_Target)
			Modallessdialog()
		Else
			DirRemove($Set_Target & "\ISO", 1)
			DirCreate($Set_Target & "\ISO")
			;DirCreate($Set_Target & "\ISO\" & $time)

			GUICtrlSetData($WaikLocation_Input, $Set_Target)
			If $Set_Target = "" Then
				$Set_Target = @HomeDrive & "\"
				GUICtrlSetData($WaikLocation_Input, $Set_Target)
				GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
				_FileWriteLog($LogDir & "\SG_Recovery.log", "Target location : " & $Set_Target)
				Modallessdialog()
			Else
				Modallessdialog()
				GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
				_FileWriteLog($LogDir & "\SG_Recovery.log", "Target location : " & $Set_Target)
			EndIf

			; Check whether the Target drive is accessiable (if you give a CD Drive as a Target location it shows an error )
			If Not FileExists($Set_Target) Or  DriveGetType($Set_Target,1) = ("CDROM") then
				MsgBox(16, $ProductName & " Alerts", "ISO can only save on Local or Network drive")
				_FileWriteLog($LogDir & "\SG_Recovery.log", "ISO can only save on Local or Network drive")
				$Set_Target = @HomeDrive & "\"
			    GUICtrlSetData($WaikLocation_Input, $Set_Target)
			    GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
			EndIf

		EndIf
		Modallessdialog()
		GUICtrlSetTip($WaikLocation_Input, "Target Location : " & $Set_Target)
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Target location : " & $Set_Target)
	EndIf
EndFunc   ;==>browse

Func browse1()
	; Function for browsing the Waik Location
	GUICtrlSetData($progress_bar1, 0)

	$Aik_Target = FileSelectFolder("Choose a folder.", "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", 1)
	GUICtrlSetData($TargetLocation_Input, $Aik_Target)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Windows AIK/ADK Location : " & $Aik_Target)

	;checking ADK  or AIK and constructing the Tools Path
	If FileExists($Aik_Target & "\PETools") Then
	   $Win_PE_Tools_Path ="\PETools"
	   $Win_PE_Cabinet_path = "\WinPE_FPs"
	   $Dism_path = "\Servicing"
	   $OscdImage_path = "\"& $Version
	   $isWinAdk = 0
	ElseIf FileExists($Aik_Target & "\Windows Preinstallation Environment") Then
	   $Win_PE_Tools_Path = "\Windows Preinstallation Environment"
	   $Win_PE_Cabinet_path = "\WinPE_OCs"
	   $Dism_path ="\Deployment Tools\"& $Version &"\DISM"
	   $OscdImage_path = "\Deployment Tools\"&$Version&"\Oscdimg"
	   $isWinAdk = 1
	EndIf
   _FileWriteLog($LogDir & "\SG_Recovery.log", "End of FileExists check in Browsel")

	;
	If $Aik_Target = "Computer" Then
		Modaldialog()
		GUICtrlSetData($TargetLocation_Input, "")
		MsgBox(16, $ProductName & " Alerts", "Invalid Location .Try Some other Location")
		Find_Waik_Location()
		Modallessdialog()
	EndIf
	If $Aik_Target = "" Then
		GUICtrlSetData($TargetLocation_Input, "")
		Find_Waik_Location()
		Modallessdialog()
	Else
		Modallessdialog()
		GUICtrlSetTip($TargetLocation_Input, "Windows AIK Location : " & $Aik_Target)
	EndIf



EndFunc   ;==>browse1


Func browseDriver()
	; Function for browsing the Driver Location
	$Drv_Target = FileSelectFolder("Choose a folder.", "", 5, @HomeDrive & "\")
	Local $error9 = FileGetAttrib($Drv_Target)

	If $Drv_Target = "" Then
		$Drv_Target = @HomeDrive & "\"
		GUICtrlSetData($Additional_Driver_Location_Input, $Drv_Target)
		GUICtrlSetTip($Additional_Driver_Location_Input, "Additional Driver Location : " & $Drv_Target)
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Additional Driver location : " & $Drv_Target)
		Modallessdialog()
	Else
		;Check if Additional Driver location is null or computer or Libraries it will show an error
		If $error9 = "" Or $Drv_Target = "Computer" Or $Drv_Target = "Libraries" Then
			Modaldialog()
			MsgBox(16, $ProductName & " Alerts", "Invalid Location .Try Some other Location")
			$Drv_Target = @HomeDrive & "\"
			GUICtrlSetData($Additional_Driver_Location_Input, $Drv_Target)
			GUICtrlSetTip($Additional_Driver_Location_Input, "Additional Driver location : " & $Drv_Target)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code File GET Attrib" & $error9)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Additional Driver Location : " & $Drv_Target)
			Modallessdialog()
		Else
			GUICtrlSetData($Additional_Driver_Location_Input, $Drv_Target)
			Local $var = DriveStatus($Drv_Target)
			If $Drv_Target = "" Then
				$Drv_Target = @HomeDrive & "\"
				GUICtrlSetData($Additional_Driver_Location_Input, $Drv_Target)
				GUICtrlSetTip($Additional_Driver_Location_Input, "Additional Driver location : " & $Drv_Target)
				_FileWriteLog($LogDir & "\SG_Recovery.log", "Additional Driver location : " & $Drv_Target)
				Modallessdialog()
			Else
				Modallessdialog()
				GUICtrlSetTip($Additional_Driver_Location_Input, "Additional Driver location : " & $Drv_Target)
				;_FileWriteLog($LogDir & "\SG_Recovery.log", "Additional Driver location : " & $Drv_Target)
			EndIf

		EndIf
		Modallessdialog()
		GUICtrlSetTip($Additional_Driver_Location_Input, "Additional Driver location : " & $Drv_Target)
		_FileWriteLog($LogDir & "\SG_Recovery.log", "TAdditional Driver location : " & $Drv_Target)
	EndIf


EndFunc   ;==>browseDriver



; 	It Does Not allow you to access background Window

Func Modaldialog()

	GUISetState(@SW_DISABLE, $gui)

EndFunc   ;==>Modaldialog
;==>  	End  Modaldialog()


; It allow you to access background Window

Func Modallessdialog()

	GUISetState(@SW_RESTORE, $gui)
	GUICtrlSetState($gui, $GUI_FOCUS)
	GUISetState(@SW_ENABLE, $gui)
	GUISetState(@SW_SHOW, $gui)

EndFunc   ;==>Modallessdialog
;==>	End Modallessdialog


Func Checkfiles()

	;FileExists(@ScriptDir&"\bin")
	If FileExists(@ScriptDir & "\tools\bmr.exe") And FileExists(@ScriptDir & "\images") Then
		TempSpace()
	Else
		Modaldialog()
		MsgBox(64, $ProductName & " Alerts", $ProductName & " Tools Component Missing!" & @CRLF & "Contact - " & $SupportMailID)
		_FileWriteLog($LogDir & "\SG_Recovery.log", $ProductName & " Tools Component Missing . Missing " & $ProductName & " exe in tools Folder ")
		Modallessdialog()
	EndIf

EndFunc   ;==>Checkfiles



; ---- Find If temporary folder have more than 1.5 GB ---------

Func TempSpace()

	Global $tempspace = DriveSpaceFree(@TempDir)

	If $tempspace < 1536 Then
		Modaldialog()
		MsgBox(64, $ProductName & " Alerts", "Not Sufficent space for store Temporary Files . Need 1.5 GB or more free space in Boot Volume(Running OS Partition) ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", " Temp Folder Does Not have suffiecent space to store temp files ")
		Modallessdialog()
	Else
		TargetSpace()
	EndIf
EndFunc   ;==>TempSpace

;==> 			End TempSpace				----




Func TargetSpace()

	Global $space = DriveSpaceFree($Set_Target)
	; Find Free space on target drive if less than 500 mb it does not allow you to create iso
	If $space < 500 Then
		Modaldialog()
		MsgBox(64, $ProductName & " Alerts", "Target Space is Lesser than 500 mb ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Target Space is Lesser than 500 mb  ")
		Modallessdialog()
		; Find  If Target is Null "Null means it doesnot allow you to continue"
	ElseIf $Aik_Target = "" Then
		Modaldialog()
		MsgBox(64, $ProductName & " Alerts", "Windows AIK Location cannot be empty. Select the WAIK Installed location for build SCRecovery CD " & @CRLF & " Eg  C:\Program Files\WindowsAIK")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Windows AIK Location cannot be empty ")
		Modallessdialog()
		; Find Free space on target drive is greater than 2 gb when target and temp folder are  same
	ElseIf $Set_Target = @HomeDrive & "\" Then
		If $space < 2048 Then
			Modaldialog()
			MsgBox(64, "Alerts", $Set_Target & "Temporary directory and target are same" & @HomeDrive & " . Need 2 GB or More Free Space For Creating ISO ")
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Temporary directory and target are same . Need 2 GB or More Free Space For Creating ISO ")
			Modallessdialog()
		Else
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Target Free Space" & $space)
			AikDir()
		EndIf
	Else
		AikDir()
	EndIf

EndFunc   ;==>TargetSpace



; Set the Directory which the dism exe ocurs

Func AikDir()
	GUICtrlSetData($label_3, "")
	GUICtrlSetData($ProgressLabel, "")
	If FileExists($Aik_Target & $Win_PE_Tools_Path) Then
		$Aik = ($Aik_Target)
		DirRemove($Set_Target & "\ISO", 1)
		DirCreate($Set_Target & "\ISO")
		Find_Aik_Dir()
	Else
		Modaldialog()
		MsgBox(64, $ProductName & " Alerts", "Windows AIK/ADK  PE tools Folder Does Not Exist in the given location " & @CRLF & @CRLF & $Aik_Target)
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Windows AIK/ADK  PE tools Folder Does Not Exist in the given location " &$Aik_Target)
		Modallessdialog()
	EndIf

EndFunc   ;==>AikDir


; Set the time stamp and create folder in temporary folder

Func Find_Aik_Dir()
	$time = @YEAR & '_' & @MON & '_' & @MDAY & '_' & @HOUR & '_' & @MIN
	$folder = @TempDir & "\" & $time;//create  folder in temp Dir
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Windows Tempfolder " & $folder)
	DirCreate($folder)
	GUICtrlSetState($Build_Bn, $GUI_DISABLE)
	GUICtrlSetState($Browse_Bn, $GUI_DISABLE)
	GUICtrlSetState($Browse_Bn1, $GUI_DISABLE)
	GUICtrlSetState($Addtinal_Driver_Button, $GUI_DISABLE)
	GUICtrlSetState($Cancel_Bn, $GUI_DISABLE)
	GUICtrlSetData($ProgressLabel, "Initializing... ")
	Sleep(5000)
	TrayTip($ProductName & " Alerts", "Creating " & $Set_Target & " Recovery CD ISO ", 10, 1)

	Local $Command
	If $isWinAdk =1 Then
	   $BootWIMTempSourceLoc = "\Temp\media\sources\boot.wim"
	   $BootWIMTempTargetLoc = "\Temp\media\sources\boot.wim"
	  $Command = ('"' & $Aik & '\Deployment Tools\DandISetEnv.bat' & '" ' &' && copype ' )
   Else
	  $BootWIMTempSourceLoc = "\Temp\winpe.wim"
	  $BootWIMTempTargetLoc = "\Temp\ISO\sources\boot.wim"
	  $Command = ('"' & $Aik & '\PETools\' & 'copype.cmd' & '" ')
   EndIf

	Local $CopyPeCommand = ($Command & $Version & ' "' & $folder & "\Temp" & '"')

	_FileWriteLog($LogDir & "\SG_Recovery.log", "Windows WinPEfiles copy call " & $CopyPeCommand)
	$changedir1 = RunWait( $CopyPeCommand, "", @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $changedir1)
	GUICtrlSetData($ProgressLabel, "Copying Files ...")
	;;===================================================
	Local $Error4 = RunWait(FileCopy($folder & $BootWIMTempSourceLoc, $folder & $BootWIMTempTargetLoc))

		_FileWriteLog($LogDir & "\SG_Recovery.log", "4: Error in copying Wim Files ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $Error4)
	;;===================================================
	GUICtrlSetData($ProgressLabel, "Copying Files ...")
	GUICtrlSetData($progress_bar1, Round((1 / 12) * 100, 0))
	Dism()

EndFunc   ;==>Find_Aik_Dir




;Function for mounting on the directory
Func Dism()
	  Local $mountPath = '"' & $Aik & $Dism_path & '\Dism' & '"' & " /Mount-wim /WimFile:"
	  _FileWriteLog($LogDir & "\SG_Recovery.log", "Mounting Wim Files " & $mountPath)
	Local $Error4 = RunWait('"' & $Aik & $Dism_path & '\Dism' & '"' & " /Mount-wim /WimFile:" & $folder & $BootWIMTempTargetLoc & " /index:1 /MountDir:" & $folder & "\Temp\mount", $folder, @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Mounting Wim Files ")

	If $Error4 <> 0 Then
		_FileWriteLog($LogDir & "\SG_Recovery.log", "4: Error in Mounting Wim Files ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $Error4)
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", " Error in Mounting Wim Files ")
		Modallessdialog()
		For $i = Round((1 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()

	Else
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Wim files Sucessully mounted ")
		GUICtrlSetData($progress_bar1, Round((2 / 12) * 100, 0))
		GUICtrlSetData($ProgressLabel, "Mounting the wim file ...")
		Package0()
		;InstallingDrivers() ;for testing only
	EndIf

EndFunc   ;==>Dism



Func Package0()

	GUICtrlSetData($ProgressLabel, "(1/5) Installing Package wmi...")
	Local $error5 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' &' /image:' & $folder & '\Temp\mount /Add-Package /PackagePath:' & '"' & $Aik & $Win_PE_Tools_Path & '\' & $Version & $Win_PE_Cabinet_path & '\winpe-wmi.cab ' & '"', "", @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-wmi.cab")

	If $error5 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error installing Cab File")
		Modallessdialog()
		For $i = Round((2 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()
		_FileWriteLog($LogDir & "\SG_Recovery.log", "5:Error in Adding Package winpe-wmi.cab")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error5)

	Else
		GUICtrlSetData($progress_bar1, Round((3 / 12) * 100, 0))
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-wmi.cab Sucessfully")
		Package1()
	EndIf
EndFunc   ;==>Package0



Func Package1()

	GUICtrlSetData($ProgressLabel, "(2/5) Installing Package hta ...")
	Local $error6 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' & ' /image:' & $folder & '\Temp\mount /Add-Package /PackagePath:' & '"' & $Aik & $Win_PE_Tools_Path & '\' & $Version & $Win_PE_Cabinet_path & '\winpe-hta.cab ' & '"', "", @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-hta.cab")

	If $error6 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error installing Cab File")
		Modallessdialog()
		For $i = Round((3 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()

		_FileWriteLog($LogDir & "\SG_Recovery.log", "6: Error in Adding Package winpe-hta.cab")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error6)
	Else
		GUICtrlSetData($progress_bar1, Round((4 / 12) * 100, 0))
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-hta.cab sucessfully")
		Package2()
	EndIf
EndFunc   ;==>Package1



Func Package2()
	GUICtrlSetData($ProgressLabel, "(3/5) Installing Package winpe-mdac...")
	Local $error7 = RunWait('"' & $Aik & $Dism_path&'\Dism' & '"' & ' /image:' & $folder & '\Temp\mount /Add-Package /PackagePath:' & '"' & $Aik & $Win_PE_Tools_Path & '\' & $Version & $Win_PE_Cabinet_path & '\winpe-mdac.cab ' & '"', "", @SW_HIDE)

	_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-mdac.cab ")
	If $error7 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error installing Cab File")
		Modallessdialog()
		For $i = Round((4 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()
		_FileWriteLog($LogDir & "\SG_Recovery.log", "7: Error in Adding Package winpe-mdac.cab")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error7)
	Else
		GUICtrlSetData($progress_bar1, Round((5 / 12) * 100, 0))
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-mdac.cab Sucessfully")
		Package3()
	EndIf

EndFunc   ;==>Package2



Func Package3()

	GUICtrlSetData($ProgressLabel, "(4/5) Installing Package winpe-scripting  ...")
	Local $error8 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' & ' /image:' & $folder & '\Temp\mount /Add-Package /PackagePath:' & '"' & $Aik & $Win_PE_Tools_Path & '\' & $Version & $Win_PE_Cabinet_path & '\winpe-scripting.cab ' & '"', "", @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-scripting.cab")

	If $error8 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error installing Cab File")
		Modallessdialog()
		For $i = Round((5 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()
		_FileWriteLog($LogDir & "\SG_Recovery.log", "8: Error in Adding Package winpe-scripting.cab")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error8)

	Else
		GUICtrlSetData($progress_bar1, Round((6 / 12) * 100, 0))
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-scripting.cab SucessFully")
		Package4()
	EndIf

EndFunc   ;==>Package3



Func Package4()

	GUICtrlSetData($ProgressLabel, "(5/5) Installing Package  winpe-wds-tools ...")
	Local $error9 = RunWait('"' & $Aik & $Dism_path  &'\Dism' & '"' & ' /image:' & $folder & '\Temp\mount /Add-Package /PackagePath:' & '"' & $Aik & $Win_PE_Tools_Path & '\' & $Version & $Win_PE_Cabinet_path & '\winpe-wds-tools.cab ' & '"', "", @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-wds-tools.cab")

	If $error9 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error installing Cab File")
		Modallessdialog()
		For $i = Round((6 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()

		_FileWriteLog($LogDir & "\SG_Recovery.log", "9: Error in Adding Package winpe-wds-tools.cab")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error9)

	Else
		GUICtrlSetData($progress_bar1, Round((7 / 12) * 100, 0))
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Adding Package winpe-wds-tools.cab Sucessfully ")
		;MountingPackages()
		InstallingDrivers()
	EndIf

EndFunc   ;==>Package4



Func MountingPackages() ;not needed
	GUICtrlSetData($ProgressLabel, "Installing Packages:Mounting  ...")
	Local $error10 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' &' /image:' & $folder & '\Temp\mount\ /Get-Packages', "", @SW_HIDE)

	_FileWriteLog($LogDir & "\SG_Recovery.log", "Get Packages From image ")
	If $error10 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error Mounting packages ")
		Modallessdialog()
		For $i = Round((7 / 12) * 100) To 10 Step -1
			GUICtrlSetData($progress_bar1, $i)
			Sleep(5)
		Next
		Enablebutton()

		_FileWriteLog($LogDir & "\SG_Recovery.log", "10 : Error in Get Packages From image ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error10)

	Else
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Get Packages From image ")
		GUICtrlSetData($progress_bar1, Round((8 / 12) * 100, 0))
	EndIf
	InstallingDrivers()

EndFunc   ;==>MountingPackages



Func InstallingDrivers()

	Local $error9 = FileGetAttrib($Drv_Target)

	If $Drv_Target = "" Or $error9 = "" Then
		GUICtrlSetData($progress_bar1, Round((9 / 12) * 100, 0))
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error in Installing Additional Drivers ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error9)
	Else
		GUICtrlSetData($ProgressLabel, "Installing Additional Drivers  ...")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Installing Additional Drivers ")
		Local $error101 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' & ' /image:' & $folder & '\Temp\mount\ /Add-Driver:' & $Drv_Target & ' /recurse', "", @SW_HIDE)

		If $error101 <> 0 Then
			_FileWriteLog($LogDir & "\SG_Recovery.log", "10 : Error in Installing Additional Drivers ")
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error101)
		Else
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Installed Additional Drivers sucessfully")
			GUICtrlSetData($progress_bar1, Round((9 / 12) * 100, 0))
		EndIf
	EndIf

	SetupPEenv()

EndFunc   ;==>InstallingDrivers

Func SetupPEenv()

	GUICtrlSetData($ProgressLabel, "Updating PE settings  ...")
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Setting PE settings ")
	Local $error101 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' & ' /image:' & $folder & '\Temp\mount\ /Set-ScratchSpace:512', "", @SW_HIDE)

	If $error101 <> 0 Then
		_FileWriteLog($LogDir & "\SG_Recovery.log", "10 : Error in Updating PE settings ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error101)
	Else
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Updated PE settings sucessfully")
		GUICtrlSetData($progress_bar1, Round((9 / 12) * 100, 0))
	EndIf


	CopyFiles()

EndFunc   ;==>SetupPEenv

Func CopyFiles()

	$pemount = ($folder & '\Temp\mount\Program Files\' & $ProductName)
	DirCopy(@ScriptDir & "\tools", $pemount, 1)
	;GUICtrlSetData($progress_bar1, 70)
	GUICtrlSetData($progress_bar1, Round((9 / 12) * 100, 0))
	Local $Error1 = FileCopy(@SystemDir & "\findstr.exe", $folder & "\Temp\mount\Windows\System32\")
   _FileWriteLog($LogDir & "\SG_Recovery.log", " findstr.exe Error Code : " & $Error1)
	DirCreate($folder & "\Temp\mount\Windows\System32\config\systemprofile\Desktop")

	;;==================FOR Automatic Launch VembuBDR When Booting From Recovery CD ==========================

	Local $Error2 = FileCopy(@ScriptDir & "\PEConf\Winpeshl.ini", $folder & "\Temp\mount\Windows\System32\*.*")

	_FileWriteLog($LogDir & "\SG_Recovery.log", "Winpeshl.ini Error  Code : " & $Error2)

	Local $Error3 = FileCopy(@ScriptDir & "\tools\ReplaceString.exe", $folder & "\Temp\mount\Windows\System32\*.*")

   _FileWriteLog($LogDir & "\SG_Recovery.log", "ReplaceString.exe Error  Code : " & $Error3)
	;;===================================================================================================

	_FileWriteLog($LogDir & "\SG_Recovery.log", "Copying Files to windows ")

	If $Error3 <> 0 Then
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error in Copying Findstring File ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $Error3)
	EndIf
	unmount()

EndFunc   ;==>CopyFiles


Func ErrorUnmount()

	GUICtrlSetData($ProgressLabel, "Please Wait Unmounting the Wim files")
	Local $Error15 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' & ' /unmount-Wim /MountDir:' & $folder & '\Temp\mount /Commit', "", @SW_HIDE)
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Unmounting Wim Files ")
	GUICtrlSetData($ProgressLabel, "Please wait Unmounting the wim files   ...")

	If $Error15 <> 0 Then
		Modaldialog()
		MsgBox(16, $ProductName & " Alerts", "Error Unmounting the Temp Files ")
		Modallessdialog()
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Unmounting Wim Files ")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $Error15)
		GUICtrlSetData($progress_bar1, 0)
	Else
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Sucessfully Unmounted Wim Files ")
		GUICtrlSetData($progress_bar1, 0)
		DirRemove($folder & "\Temp", 1)
	EndIf
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Unmounting Wim Files ")

EndFunc   ;==>ErrorUnmount

Func unmount()
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Unmounting Wim Files ")
	Local $folder1 = $Set_Target & "\ISO"
	If FileExists($folder1) Then
		GUICtrlSetData($ProgressLabel, "Unmounting the wim files   ...")
		_FileWriteLog($LogDir & "\SG_Recovery.log", "Started Unmounting Wim Files ")

		Local $error13 = RunWait('"' & $Aik & $Dism_path &'\Dism' & '"' & " /unmount-Wim /MountDir:" & $folder & "\Temp\mount /commit", "", @SW_HIDE)

		If $error13 <> 0 Then
			Modaldialog()
			MsgBox(16, $ProductName & " Alerts", "Error Unmounting the Temp Files ")
			Modallessdialog()
			For $i = Round((9 / 12) * 100) To 10 Step -1
				GUICtrlSetData($progress_bar1, $i)
				Sleep(5)
			Next
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $error13)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Unmounting Wim Files ")
		Else
			GUICtrlSetData($progress_bar1, 85)
			GUICtrlSetData($progress_bar1, Round((10 / 12) * 100, 0))
			isobuild()
		EndIf
	Else

		Local $Alert = MsgBox(1, $Set_Target & " Alerts ", "Target Folder  Does not Exist Do you Want To Create now ")

		If $Alert = 1 Then
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Target Folder is Not Present ")
			browse()
			unmount()
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Unmounting Wim Files ")
		Else
			For $i = Round((9 / 12) * 100) To 10 Step -1
				GUICtrlSetData($progress_bar1, $i)
				Sleep(5)
			Next
			Enablebutton()
			;Exit
		EndIf
	EndIf
EndFunc   ;==>unmount


; Here it Enable the Build and cancel butoon on Error
Func Enablebutton()

	GUICtrlSetData($ProgressLabel, " Please wait Deleting the temp files ")
	ErrorUnmount()
	GUICtrlSetData($ProgressLabel, "")
	GUICtrlSetState($Build_Bn, $GUI_DEFBUTTON)
	GUICtrlSetState($Build_Bn, $GUI_FOCUS)
	GUICtrlSetState($Build_Bn, $GUI_ENABLE)
	GUICtrlSetState($Build_Bn, $GUI_ONTOP)
	GUICtrlSetState($Build_Bn, $GUI_SHOW)
	GUICtrlSetState($Cancel_Bn, $GUI_ENABLE)
	GUICtrlSetState($Cancel_Bn, $GUI_ONTOP)
	GUICtrlSetState($Cancel_Bn, $GUI_SHOW)
	GUICtrlSetState($Cancel_Bn, $GUI_ONTOP)
	GUICtrlSetState($Browse_Bn, $GUI_ENABLE)
	GUICtrlSetState($Browse_Bn, $GUI_ONTOP)
	GUICtrlSetState($Browse_Bn, $GUI_SHOW)
	GUICtrlSetState($Browse_Bn1, $GUI_ENABLE)
	GUICtrlSetState($Browse_Bn1, $GUI_ONTOP)
	GUICtrlSetState($Browse_Bn1, $GUI_SHOW)
	GUICtrlSetState($Addtinal_Driver_Button, $GUI_ENABLE)
	GUICtrlSetState($Addtinal_Driver_Button, $GUI_ONTOP)
	GUICtrlSetState($Addtinal_Driver_Button, $GUI_SHOW)
	Return

EndFunc   ;==>Enablebutton

; Function for Iso Build
Func isobuild()
	_FileWriteLog($LogDir & "\SG_Recovery.log", "Iso Creation In progress ")
	If $g_DestinationType="ISO" Then
		GUICtrlSetData($ProgressLabel, "Creating ISO in Progress  ...")
	Else
		GUICtrlSetData($ProgressLabel, "Creating USB Recovery media  ...")
	EndIf
	

	Local $folder2 = $Set_Target & "\ISO"
	If FileExists($folder2) Then
		; Check if Version is X86 or X64 for the Iso name
		If $Version = "x86" Then
			$Isoname = $ProductName & "_Recovery_CD_x86.iso"
		Else
			$Isoname = $ProductName & "_Recovery_CD_x64.iso"
		EndIf
		 _FileWriteLog($LogDir & "\SG_Recovery.log", "Going to create ISO ")
	    Local $OscdImgPath = '"' & $Aik & $OscdImage_path & "\oscdimg.exe " & '"'
		 _FileWriteLog($LogDir & "\SG_Recovery.log", "Going to create ISO " & $OscdImgPath )

		 Local $etfsBootPath, $WIMBootFilePath
		 If $isWinAdk = 1 Then
			$etfsBootPath = "\Temp\fwfiles\"
			$WIMBootFilePath = "\Temp\media\"
		 Else
			$etfsBootPath = "\Temp\"
			$WIMBootFilePath = "\Temp\ISO "
		 EndIf

		;Local $Error14 = RunWait('"' & $Aik & $OscdImage_path & "\oscdimg.exe " & '"' & "-n -b" & $folder &$etfsBootPath & "etfsboot.com " & $folder & $WIMBootFilePath & '"' & $Set_Target & "\ISO\" & $Isoname & '"', "", @SW_HIDE)
		 ;_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $Error14)
		
		Local $Command = ('"' & $Aik & '\Deployment Tools\DandISetEnv.bat' & '" ' &' && Makewinpemedia ')
		Local $MakePeCommand
		If $g_DestinationType="ISO" Then
			$MakePeCommand = ($Command & '/iso /f ' & $folder & '\Temp\ ' & '"' & $Set_Target & "\ISO\" & $Isoname & '"')
		Else
			FormatDisk($g_SelectedDriveLetter ,$g_PartitioningType)
			$MakePeCommand = ($Command & '/ufd /f ' & $folder & '\Temp\ ' & '"' & $g_SelectedDriveLetter & '"')
		EndIf

		_FileWriteLog($LogDir & "\SG_Recovery.log", "Windows PE BootMake  call " & $MakePeCommand)
		Local $Error14 = RunWait( $MakePeCommand, "", @SW_HIDE)
		
		
		If $Error14 <> 0 Then
			Modaldialog()
			MsgBox(16, $ProductName & " Alerts", "Error creating Iso File")
			Modallessdialog()
			GUICtrlSetData($ProgressLabel, "Error creating Iso File")
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error Code : " & $Error14)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Error creating Iso File")
			GUICtrlSetData($progress_bar1, 0)
		Else
			GUICtrlSetData($progress_bar1, 100)
			TrayTip($ProductName & " Alerts", " ISO Sucessfully Created ", 10, 1)
			If GUICtrlRead($retainTempFiles) = 1 Then
				FileDelete($folder & "\Temp\winpe.wim")
				;MsgBox(0, "Temporary Files Location", "Recovery CD ISO files avalable at :" & $folder & "\Temp\ISO")
			Else
				DirRemove($folder, 1)
			EndIf

			GUICtrlSetData($ProgressLabel, "ISO Sucessfully Created ")
			GUICtrlSetState($Finish_Bn, $GUI_ENABLE)
			GUICtrlSetState($Finish_Bn, $GUI_SHOW)
			GUICtrlSetState($Finish_Bn, $GUI_ONTOP)
			GUICtrlSetState($Finish_Bn, $GUI_DEFBUTTON)
			GUICtrlSetState($Finish_Bn, $GUI_FOCUS)
			GUICtrlSetData($label_3, "ISO Sucessfully Created Find your ISO in " & $Set_Target & "\ISO\" & $Isoname)
			GUICtrlSetColor($label_3, 0x254117)
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Iso Created Sucessfully ")
			Sleep(3000)
			If $g_DestinationType="ISO" Then
				TrayTip($ProductName & " Alerts", "Find your ISO in " & $Set_Target & "\ISO\" & $Isoname, 10, 1)
				If StringLen($Set_Target) > 3 Then
					Run("explorer.exe " & $Set_Target & "\ISO")
					_FileWriteLog($LogDir & "\SG_Recovery.log", $Set_Target & "\ISO\")
				Else
					Run("explorer.exe " & $Set_Target & "ISO")
				EndIf
			Else
				TrayTip($ProductName & " Alerts", "USB Recovery Media Written Successfully ", 10, 1)
			EndIf
			
			Exit
		EndIf
	Else
		Local $Alert = MsgBox(1, $ProductName & " Alerts ", "Target Folder  Does not Exist Do you Want To Create now ")

		If $Alert = 1 Then
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Target Folder is Not Present ")
			browse()
			isobuild()
			_FileWriteLog($LogDir & "\SG_Recovery.log", "Unmounting Wim Files ")
		Else
			For $i = Round((9 / 12) * 100) To 10 Step -1
				GUICtrlSetData($progress_bar1, $i)
				Sleep(5)
			Next
			Enablebutton()
			;Exit
		EndIf
	EndIf
EndFunc   ;==>isobuild


;===========================================================================
; Function    : _BKColor( backgroundcolor, controlID, textcolor )
; Description   : Sets the background color of a control. (Transparent Label)
;              : Sets the text color of a control.
; Author        : Thunder-man (Frank Michalski)
; Date        : 19. September 2007
; Version      : V 1.20
; Example  :     _BKColor()                             :Transparent
;               _BKColor( -1, $MyLabel)                :Transparent
;               _BKColor(0x00ff00)                      :Color Green
;               _BKColor(0x00ff00, $MyLabel)              :Color Green
;               _BKColor( -1, $MyLabel, 0x00ff00)   :Text Color Green
;===========================================================================
Func _BKColor($BackColor_ = "", $GuiID_ = -1, $Textcolor_ = 0x000000)
	If $BackColor_ = "" Or $BackColor_ = -1 Then
		GUICtrlSetBkColor($GuiID_, $GUI_BKCOLOR_TRANSPARENT)
		GUICtrlSetColor($GuiID_, $Textcolor_)
	Else
		GUICtrlSetBkColor($GuiID_, $BackColor_)
		GUICtrlSetColor($GuiID_, $Textcolor_)
	EndIf
EndFunc   ;==>_BKColor
;=======================================================================


Func GetADKInstallPathFromRegistry($OSVersion = "", $OSArch ="")
   Local $keyVal
   $keyVal = "KitsRoot" &$OSVersion
   If $OSArch = "X64" Then
		  $Win_ADKPath = RegRead("HKLM\Software\Wow6432Node\Microsoft\Windows Kits\Installed Roots", $keyVal )
		 _FileWriteLog($LogDir & "\SG_Recovery.log", "Windows OS version " & $OSVersion & " OSArch "& $OSArch & " Windows Aik Location : " & $Win_ADKPath)
   Else
		 $Win_ADKPath = RegRead("HKLM\Software\Microsoft\Windows Kits\Installed Roots", $keyVal)
		  _FileWriteLog($LogDir & "\SG_Recovery.log", "Windows OS version " & $OSVersion & " OSArch "& $OSArch & " Windows Aik Location : " & $Win_ADKPath)
   EndIf
Return $Win_ADKPath
EndFunc

; Function to create the media type selection page
Func MediaTypeSelectionPage()
    Local $guiMediaType = GUICreate("Select Destination Media Type", 400, 200)
    Local $labelMediaType = GUICtrlCreateLabel("Please select the destination media type:", 10, 10, 380, 20)
    Local $radioUSB = GUICtrlCreateRadio("USB Flash Drive", 10, 40, 150, 20)
    Local $radioISO = GUICtrlCreateRadio("ISO Drive", 10, 70, 150, 20)
    GUICtrlSetState($radioUSB, $GUI_CHECKED) ; Default selection
    Local $buttonNext = GUICtrlCreateButton("Next", 150, 150, 100, 30)
    GUISetState(@SW_SHOW, $guiMediaType)

    ; Media type selection loop
    While 1
        Local $msgMediaType = GUIGetMsg()
        If $msgMediaType = $GUI_EVENT_CLOSE Then Exit
        If $msgMediaType = $buttonNext Then
            If GUICtrlRead($radioUSB) = $GUI_CHECKED Then
                $g_DestinationType = "USB"
                GUIDelete($guiMediaType)
                USBSelectionPage()
            ElseIf GUICtrlRead($radioISO) = $GUI_CHECKED Then
                $g_DestinationType = "ISO"
                GUIDelete($guiMediaType)
                ;MainPage()
            EndIf
            ExitLoop
        EndIf
    WEnd

    ;GUIDelete($guiMediaType)
    ;Exit
EndFunc

; Function to create the USB selection page

Func USBSelectionPage()
    Local $guiUSB = GUICreate("Select USB Drive", 500, 300)
    Local $labelUSB = GUICtrlCreateLabel("Select a USB flash drive to use as recovery media ", 10, 10, 480, 20)
    Local $listviewUSB = GUICtrlCreateListView("Caption|Model|Size(In GB)|DriveLetter", 10, 40, 480, 200)
    Local $buttonUSBNext = GUICtrlCreateButton("Next", 200, 250, 100, 30)
; Update USB drive listing
    _UpdateUSBList($listviewUSB)

    GUISetState(@SW_SHOW, $guiUSB)

    ; Monitor USB flash drives
    While 1
        ; Update USB drive listing
        _UpdateUSBList($listviewUSB)

        ; Check if any USB drive is listed
        Local $itemCount = _GUICtrlListView_GetItemCount($listviewUSB)
        If $itemCount > 0 Then
            ; Check for GUI messages
            While 1
                Local $msgUSB = GUIGetMsg()
                If $msgUSB = $GUI_EVENT_CLOSE Then Exit
                If $msgUSB = $buttonUSBNext Then
                    Local $selected = _GUICtrlListView_GetSelectedIndices($listviewUSB)
					If $selected < 0 Then
                        MsgBox(64, "Selection", "No USB drive selected.")
                    Else
						$g_SelectedUSB = $selected
						$g_SelectedUSB = $g_SelectedUSB + 1 
						;$g_USBDetails = _GUICtrlListView_GetItemText($listviewUSB, $g_SelectedUSB, 0) & " | " & _GUICtrlListView_GetItemText($listviewUSB, $g_SelectedUSB, 1) & " | " & _GUICtrlListView_GetItemText($listviewUSB, $g_SelectedUSB, 2) & " | " & _GUICtrlListView_GetItemText($listviewUSB, $g_SelectedUSB, 3)
                        ;$g_SelectedDriveLetter = _GUICtrlListView_GetItemText($listviewUSB, $g_SelectedUSB, 3)
						$g_USBDetails = $g_USBLists[$g_SelectedUSB][1]
                        $g_SelectedDriveLetter = $g_USBLists[$g_SelectedUSB][3]
						
						
						GUIDelete($guiUSB)
                        $g_PartitioningType = SelectPartitionStyle()
						MsgBox(64, "Selection", "The selected USB drive volume will be formatted. Click on 'OK' to proceed")
						Return
                    EndIf
                EndIf
            WEnd
			
        EndIf

        ; Delay before next check
        Sleep(2000)
    WEnd

    GUIDelete($guiUSB)
EndFunc


Func _UpdateUSBList($listviewUSB)
    Local $aDrives = _ListUSBDrives()
	$g_USBLists =  $aDrives
    ; Clear and update GUI ListView
    GUICtrlSendMsg($listviewUSB, $LVM_DELETEALLITEMS, 0, 0)
    For $i = 1 To UBound($aDrives) - 1
		
        GUICtrlCreateListViewItem($aDrives[$i][0] & "|" & $aDrives[$i][1] & "|" & $aDrives[$i][2] & "|" & $aDrives[$i][3], $listviewUSB)
    Next
EndFunc

Func _ListUSBDrives()
    Local $aDrives[1][4] = [["", "", "", ""]]
    Local $colItems = _ExecQuery("SELECT * FROM Win32_DiskDrive WHERE MediaType='Removable Media'")
    Local $iCount = 0

    If IsObj($colItems) Then
        For $objItem In $colItems
            Local $driveLetter = _GetDriveLetter($objItem.DeviceID)
            If $driveLetter <> "" Then
                ReDim $aDrives[UBound($aDrives) + 1][4]
                $aDrives[UBound($aDrives) - 1][0] = $objItem.Caption
                $aDrives[UBound($aDrives) - 1][1] = $objItem.Model
                $aDrives[UBound($aDrives) - 1][2] = Round($objItem.Size / 1073741824, 2) & " GB" ; Convert bytes to GB
                $aDrives[UBound($aDrives) - 1][3] = $driveLetter
				
                $iCount += 1
            EndIf
        Next
    EndIf

    $aDrives[0][0] = $iCount

    Return $aDrives
EndFunc

Func _GetDriveLetter($deviceID)
    Local $driveLetter = ""
    Local $colPartitions = _ExecQuery("ASSOCIATORS OF {Win32_DiskDrive.DeviceID='" & $deviceID & "'} WHERE AssocClass=Win32_DiskDriveToDiskPartition")
    If IsObj($colPartitions) Then
        For $partition In $colPartitions
            Local $colLogicalDisks = _ExecQuery("ASSOCIATORS OF {Win32_DiskPartition.DeviceID='" & $partition.DeviceID & "'} WHERE AssocClass=Win32_LogicalDiskToPartition")
            If IsObj($colLogicalDisks) Then
                For $logicalDisk In $colLogicalDisks
                    $driveLetter = $logicalDisk.DeviceID
                Next
            EndIf
        Next
    EndIf
    Return $driveLetter
EndFunc

Func _ExecQuery($sQuery)
    Local $oWMIService = ObjGet("winmgmts:\\.\root\CIMV2")
    If Not IsObj($oWMIService) Then
        MsgBox(16, "Error", "Unable to access WMI service.")
        Return SetError(1, 0, 0)
    EndIf
    Return $oWMIService.ExecQuery($sQuery)
EndFunc

Func SelectPartitionStyle()
    Local $guiPartition = GUICreate("Select Partition Scheme ", 300, 150)
    Local $labelPartition = GUICtrlCreateLabel("Select the Partition Scheme", 10, 10, 280, 20)
    Local $radioMBR = GUICtrlCreateRadio("MBR", 10, 40, 100, 20)
    Local $radioGPT = GUICtrlCreateRadio("GPT", 10, 70, 100, 20)
    GUICtrlSetState($radioMBR, $GUI_CHECKED) ; Default selection
    Local $buttonOK = GUICtrlCreateButton("OK", 100, 100, 100, 30)
    GUISetState(@SW_SHOW, $guiPartition)

    While 1
        Local $msgPartition = GUIGetMsg()
        If $msgPartition = $GUI_EVENT_CLOSE Then
            GUIDelete($guiPartition)
            Return ""
        EndIf
        If $msgPartition = $buttonOK Then
            Local $partitionStyle = "MBR"
            If GUICtrlRead($radioGPT) = $GUI_CHECKED Then
                $partitionStyle = "GPT"
            EndIf
            GUIDelete($guiPartition)
            Return $partitionStyle
        EndIf
    WEnd
EndFunc

Func GetDiskNumberFromDriveLetter($driveLetter)
    Local $driveLetterNoColon = StringReplace($driveLetter, ":", "")
    Local $colItems = _ExecQuery("SELECT * FROM Win32_LogicalDisk WHERE DeviceID='" & $driveLetterNoColon & ":'")
    If IsObj($colItems) Then
        For $objItem In $colItems
            Local $partitionDeviceID = $objItem.DeviceID
            Local $colPartitions = _ExecQuery("ASSOCIATORS OF {Win32_LogicalDisk.DeviceID='" & $partitionDeviceID & "'} WHERE AssocClass=Win32_LogicalDiskToPartition")
            If IsObj($colPartitions) Then
                For $partition In $colPartitions
                    Local $colDisks = _ExecQuery("ASSOCIATORS OF {Win32_DiskPartition.DeviceID='" & $partition.DeviceID & "'} WHERE AssocClass=Win32_DiskDriveToDiskPartition")
                    If IsObj($colDisks) Then
                        For $disk In $colDisks
                            ; Extract the disk number
                            Local $diskID = $disk.DeviceID
                            Local $diskNumber = StringTrimLeft($diskID, StringInStr($diskID, "PHYSICALDRIVE", 0, 1) + 12)
                            Return $diskNumber
                        Next
                    EndIf
                Next
            EndIf
        Next
    EndIf
    Return -1
EndFunc

Func FormatDisk($driveLetter, $partitionStyle)
    Local $diskNumber = GetDiskNumberFromDriveLetter($driveLetter)
    If $diskNumber = -1 Then
        MsgBox(16, "Error", "Unable to determine disk number for drive letter " & $driveLetter)
        Return
    EndIf

    Local $cmd = "diskpart /s format_script.txt"
    Local $script = "select disk " & $diskNumber & @CRLF
    $script &= "clean" & @CRLF
    If $partitionStyle = "MBR" Then
        $script &= "convert mbr" & @CRLF
    Else
        $script &= "convert gpt" & @CRLF
    EndIf
    $script &= "create partition primary" & @CRLF
    $script &= "format fs=ntfs quick" & @CRLF
    $script &= "assign letter=" & StringReplace($driveLetter, ":", "") & @CRLF

    FileWrite("format_script.txt", $script)
    RunWait(@ComSpec & " /c " & $cmd, @SystemDir, @SW_HIDE)
    FileDelete("format_script.txt")

    ;MsgBox(64, "Formatting", "The USB drive has been formatted as " & $partitionStyle)
EndFunc
