@echo off

REM This Script  Creates a New BCD EDIT Entry in the machine
REM STEP 1: CHECK Which Drive Have Windows Installation.
REM				  IF No OS Drive is found Exit Script.
REM STEP 2: CHECK If The Os is Vista and Above
REM               IF OS is below Vista Exit Script, As Win2k3 and Xp does not Support BCDEDIT Operations

REM STEP 3: IF OS DRIVE IS FOUND START EXECUTING THE SCRIPT

SET D_P_HKLM_TEMP_REG="HKLM\NEWSYSTEM"

:FINDING WIN VOLUME 
ECHO Finding Windows Volume
SET WINDOWSDRIVE=
For %%A in (C D E F G H I J K L M N O) Do (
Echo %%A
IF EXIST %%A:\WINDOWS\system32 (
SET WINDOWSDRIVE=%%A:
Echo %WINDOWSDRIVE%
GOTO :WIN_VOLUME_FOUND
)
)

:WIN_VOLUME_FOUND
IF "%WINDOWSDRIVE%" == "" GOTO WINDRIVEDETECT
echo Windows is detected in "%WINDOWSDRIVE%"

REM FIND SYSTEM OS
Echo Find System OS
SET D_P_SYS32_CFG_SW="%WINDOWSDRIVE%\windows\system32\config\software"
SET D_P_REG_OS_PATH="HKLM\NEWSYSTEM\Microsoft\Windows NT\CurrentVersion"

REM Load system32/config/software to TempHive to Find OS
reg load %D_P_HKLM_TEMP_REG% %D_P_SYS32_CFG_SW%
if NOT ERRORLEVEL 0 GOTO CHECKREGLOADSOFTWARE

reg query %D_P_REG_OS_PATH% /v productname  > %WINDOWSDRIVE%\findos.txt
if ERRORLEVEL 1 (
reg unload %D_P_HKLM_TEMP_REG%
if not ERRORLEVEL 0 GOTO CHECKREGUNLOAD
GOTO :CHECKREGQUERYOSNAME
)
reg unload %D_P_HKLM_TEMP_REG%
if not ERRORLEVEL 0 GOTO CHECKREGUNLOAD

findstr /i "2003" %WINDOWSDRIVE%\findos.txt 
if NOT ERRORLEVEL 1 GOTO OS_NOT_SUPPORTED
findstr /i "XP" %WINDOWSDRIVE%\findos.txt 
if NOT ERRORLEVEL 1 GOTO OS_NOT_SUPPORTED
REM Clean findos.txt file
del %WINDOWSDRIVE%\findos.txt
Echo Begin BCD EDIT Operation

REM bootrec.exe /fixmbr
REM bootsect.exe /nt60 all /force
attrib -h -s %WINDOWSDRIVE%\boot\BCD
del %WINDOWSDRIVE%\boot\BCD
bcdedit /createstore %WINDOWSDRIVE%\boot\bcd.temp
bcdedit /store %WINDOWSDRIVE%\boot\bcd.temp /create {bootmgr} /d "Windows Boot Manager"
bcdedit /import %WINDOWSDRIVE%\boot\bcd.temp
bcdedit /set {bootmgr} device partition=%WINDOWSDRIVE%
bcdedit /timeout 10
attrib -h -s %WINDOWSDRIVE%\boot\bcd.temp
del %WINDOWSDRIVE%\boot\bcd.temp
bcdedit /create /d "Windows" /application osloader > %WINDOWSDRIVE%\tempVHDGUID.txt

echo Find the GUID in the output of the BCDEdit   
FOR /F "tokens=1* delims=}" %%G in (%WINDOWSDRIVE%\tempVHDGUID.txt) DO set GUID=%%G
FOR /F "tokens=1* delims={" %%M in ("%GUID%") DO Set GUID1=%%N
set GUID={%GUID1%}
Echo %GUID%
del %WINDOWSDRIVE%\tempVHDGUID.txt
bcdedit /set %GUID% device partition=%WINDOWSDRIVE%
bcdedit /set %GUID% osdevice partition=%WINDOWSDRIVE%
bcdedit /set %GUID% path \windows\system32\winload.exe
bcdedit /set %GUID% systemroot \windows
bcdedit /displayorder %GUID%
bcdedit /default %GUID%

EXIT 


:WINDRIVEDETECT
ECHO WINDOWS DRIVE NOT RECOGNISED
EXIT /B

:CHECKREGLOADSOFTWARE
ECHO UNABLE TO LOAD CONFIG\SOFTWARE
EXIT /B

:CHECKREGQUERYOSNAME
ECHO FAILED TO GET THE OPERATING SYSTEM NAME. REG QUERY FAILED
EXIT /B

:OS_NOT_SUPPORTED
ECHO THE OS DOES NOT SUPPORT BCDEDIT OPTION.
EXIT /B

:CHECKREGUNLOAD
ECHO REG UNLOAD FAILED
EXIT /B

